import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.business.BusinessEntity;
import org.uddi4j.response.BusinessDetailExt;
import org.uddi4j.response.BusinessEntityExt;
import org.uddi4j.transport.TransportFactory;
import java.util.Vector;

public class UDDIGetBusinessDetailExt2 {

	public static void main(String[] args) throws Exception {

		System.setProperty(TransportFactory.PROPERTY_NAME, "org.uddi4j.transport.ApacheAxisTransport");

		UDDIProxy proxy = new UDDIProxy();
		proxy.setInquiryURL("http://uddi.microsoft.com/inquire");

		Vector bkv = new Vector();
		bkv.addElement("D2033110-3AAF-11D5-80DC-002035229C64");
		bkv.addElement("0076B468-EB27-42E5-AC09-9955CFF462A3");

		BusinessDetailExt bde = proxy.get_businessDetailExt(bkv);

		Vector beev = bde.getBusinessEntityExtVector();
		if (beev.size() == 0) {
			System.out.println("no business(es) found");
			System.exit(0);
		}

		System.out.println(beev.size()+" business(es) found\n");
		for (int i = 0; i < beev.size(); i++) {
			BusinessEntityExt bee = (BusinessEntityExt)beev.elementAt(i);
			BusinessEntity be = bee.getBusinessEntity();
			System.out.println(be.getDefaultNameString());
			System.out.println(be.getBusinessKey());
			System.out.println("\n");
		}
	}
}